/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.api.machine.IMachineUpgrade;
import com.blakebr0.mysticalagriculture.api.machine.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeTier;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MachineUpgradeItem
extends BaseItem
implements IMachineUpgrade {
    private final MachineUpgradeTier tier;

    public MachineUpgradeItem(MachineUpgradeTier tier) {
        this.tier = tier;
    }

    public InteractionResult useOn(UseOnContext context) {
        IUpgradeableMachine machine;
        BlockPos pos;
        Level level = context.getLevel();
        BlockEntity tile = level.getBlockEntity(pos = context.getClickedPos());
        if (tile instanceof IUpgradeableMachine && (machine = (IUpgradeableMachine)tile).canApplyUpgrade(this.tier)) {
            ItemStack stack = context.getItemInHand();
            ItemStack remaining = machine.applyUpgrade(this);
            stack.shrink(1);
            if (!remaining.isEmpty()) {
                ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), remaining.copy());
                level.addFreshEntity((Entity)item);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            MutableComponent speed = Formatting.number((Object)(1.0 / this.tier.getOperationTimeMultiplier())).withStyle(this.tier.getTextColor());
            MutableComponent fuelRate = Formatting.number((Object)this.tier.getFuelUsageMultiplier()).withStyle(this.tier.getTextColor());
            MutableComponent fuelCapacity = Formatting.number((Object)this.tier.getFuelCapacityMultiplier()).withStyle(this.tier.getTextColor());
            MutableComponent area = Formatting.number((Object)this.tier.getAddedRange()).withStyle(this.tier.getTextColor());
            tooltip.add((Component)ModTooltips.UPGRADE_SPEED.args(new Object[]{speed}).build());
            tooltip.add((Component)ModTooltips.UPGRADE_FUEL_RATE.args(new Object[]{fuelRate}).build());
            tooltip.add((Component)ModTooltips.UPGRADE_FUEL_CAPACITY.args(new Object[]{fuelCapacity}).build());
            tooltip.add((Component)ModTooltips.UPGRADE_AREA.args(new Object[]{area}).build());
        } else {
            tooltip.add((Component)Tooltips.HOLD_SHIFT_FOR_INFO.build());
        }
    }

    @Override
    public MachineUpgradeTier getTier() {
        return this.tier;
    }
}

